/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shadow.aikar.commands;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import net.skinsrestorer.shadow.aikar.commands.CommandIssuer;
import net.skinsrestorer.shadow.aikar.commands.CommandManager;
import net.skinsrestorer.shadow.aikar.commands.SpongeCommandManager;
import net.skinsrestorer.shadow.jbannotations.NotNull;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Identifiable;

public class SpongeCommandIssuer
implements CommandIssuer {
    private final SpongeCommandManager manager;
    private final CommandSource source;

    SpongeCommandIssuer(SpongeCommandManager manager, CommandSource source) {
        this.manager = manager;
        this.source = source;
    }

    @Override
    public boolean isPlayer() {
        return this.source instanceof Player;
    }

    public CommandSource getIssuer() {
        return this.source;
    }

    @Override
    @NotNull
    public UUID getUniqueId() {
        if (this.source instanceof Identifiable) {
            return ((Identifiable)this.source).getUniqueId();
        }
        return UUID.nameUUIDFromBytes(this.source.getName().getBytes(StandardCharsets.UTF_8));
    }

    public Player getPlayer() {
        return this.isPlayer() ? (Player)this.source : null;
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }

    @Override
    public void sendMessageInternal(String message) {
        this.source.sendMessage(TextSerializers.LEGACY_FORMATTING_CODE.deserialize(message));
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.source.hasPermission(permission);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeCommandIssuer that = (SpongeCommandIssuer)o;
        return Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.source);
    }
}

